<div class="modal fade" id="editProductModal<?php echo e($product->id); ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(url('update-product/'.$product->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('PUT'); ?>
                
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title">Edit Product</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <!-- Name -->
                    <div class="mb-3">
                        <label>Name</label>
                        <input type="text" name="name" value="<?php echo e($product->name); ?>" class="form-control" required>
                    </div>

                    <!-- Image -->
                    <div class="mb-3">
                        <label>Product Image</label>
                        <?php if($product->image): ?>
                            <div class="mb-2">
                                <img src="<?php echo e(asset('storage/products/' . $product->image)); ?>" alt="<?php echo e($product->name); ?>" class="img-thumbnail" style="max-height: 100px;">
                                <small class="d-block text-muted">Current image</small>
                            </div>
                        <?php endif; ?>
                        <input type="file" name="image" class="form-control" accept="image/*">
                        <small class="text-muted">Leave empty to keep current image</small>
                    </div>

                    <div class="mb-3">
                        <label>Pack Size</label>
                        <select name="pack_size_id" class="form-select" required>
                            <option value="">Select Pack Size</option>
                            <?php $__currentLoopData = $packSizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $packSize): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($packSize->id); ?>" <?php echo e($product->pack_size_id === $packSize->id ? 'selected' : ''); ?>>
                                    <?php echo e($packSize->name); ?> (<?php echo e($packSize->quantity); ?> bottles)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Description -->
                    

                    <!-- Purchase Price -->
                    

                    <!-- Selling Price -->
                    

                    <!-- Status -->
                    <div class="mb-3">
                        <label>Status</label>
                        <select name="status" class="form-select">
                            <option value="1" <?php echo e($product->status ? 'selected' : ''); ?>>Active</option>
                            <option value="0" <?php echo e(!$product->status ? 'selected' : ''); ?>>Inactive</option>
                        </select>
                    </div>
                </div>

                <!-- Footer -->
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Update</button>
                </div>

            </form>
        </div>
    </div>
</div>
<?php /**PATH F:\www\waterPOS\resources\views/Product/edit.blade.php ENDPATH**/ ?>