<?php $__env->startSection('content'); ?>
<div class="container mt-5">

    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="p-2 border rounded">
            <strong>Order ID:</strong> <?php echo e($order->id); ?>

        </div>
        <div class="p-2 border rounded">
            <strong>Sale Date:</strong> <?php echo e(\Carbon\Carbon::parse($order->sale_date)->format('d M Y')); ?>

        </div>
    </div>

    
    <div class="card shadow-sm mb-4">
        <div class="card-body p-3">
            <div class="table-responsive">
                <table class="table table-bordered text-center align-middle mb-0">
                    <thead class="table-primary">
                        <tr>
                            <th>#</th>
                            <th class="text-start">Product Name</th>
                            <th>Quantity</th>
                            <th>Price</th>
                            <th>Subtotal</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($key + 1); ?></td>
                                <td class="text-start">
                                    <?php
                                        $product = \App\Models\Product::find($item['sku'] ?? null);
                                        $productName = $product->name ?? ($item['name'] ?? 'N/A');
                                        $packCount = $item['pack_count'] ?? $item['quantity'] ?? 0;
                                        $unitPrice = $item['unit_price'] ?? $item['price'] ?? 0;
                                        $packSizeName = $item['pack_size']['name'] ?? null;
                                        $packSizeQuantity = $item['pack_size']['bottle_quantity'] ?? ($item['pack_size_quantity'] ?? null);
                                        $totalBottles = $item['bottle_quantity'] ?? ($packSizeQuantity ? $packCount * $packSizeQuantity : null);
                                    ?>
                                    <?php echo e($productName); ?>

                                    <?php if($packSizeName && $packSizeQuantity): ?>
                                        <div class="text-secondary small">
                                            <?php echo e($packSizeName); ?> • <?php echo e($packSizeQuantity); ?> bottles/pack
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e($packCount); ?> pack(s)
                                    <?php if($totalBottles): ?>
                                        <div class="text-secondary small"><?php echo e($totalBottles); ?> bottles</div>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(env('APP_CURRENCY_SYMBOL')); ?><?php echo e(number_format($unitPrice, 2)); ?></td>
                                <td><?php echo e(env('APP_CURRENCY_SYMBOL')); ?><?php echo e(number_format($unitPrice * $packCount, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center">No items found in this order.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            
            <div class="row mt-4">
                <div class="col-md-3">
                    <strong>Fuel Charges:</strong>
                    <?php echo e(env('APP_CURRENCY_SYMBOL')); ?><?php echo e(number_format($order->fuel_charges, 2)); ?>

                </div>
                <div class="col-md-3">
                    <strong>Other Charges:</strong>
                    <?php echo e(env('APP_CURRENCY_SYMBOL')); ?><?php echo e(number_format($order->other_charges, 2)); ?>

                </div>
                <div class="col-md-3">
                    <strong>Other Charges Detail:</strong>
                    <?php echo e($order->other_charges_detail ?? '—'); ?>

                </div>
                <div class="col-md-3 text-end">
                    <strong>Subtotal:</strong>
                    <?php echo e(env('APP_CURRENCY_SYMBOL')); ?><?php echo e(number_format($order->sub_total, 2)); ?>

                </div>
            </div>

            <div class="row mt-3">
                <div class="col text-end">
                    <h4>Total: <?php echo e(env('APP_CURRENCY_SYMBOL')); ?><?php echo e(number_format($order->total, 2)); ?></h4>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-start">
        <a href="<?php echo e(url('sales')); ?>" class="btn btn-outline-secondary">Back to Stock Out List</a>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\www\waterPOS\resources\views/inventory/order-detail.blade.php ENDPATH**/ ?>