<!-- EDIT USER MODAL -->
<div class="modal fade" id="editUserModal{{ $user->id }}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Edit User</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form action="{{ url('update-user/'.$user->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="modal-body">

                    <div class="mb-3">
                        <label for="name{{ $user->id }}" class="form-label">Username</label>
                        <input type="text" id="name{{ $user->id }}" name="name" 
                               class="form-control" value="{{ $user->name }}" required>
                    </div>

                    <div class="mb-3">
                        <label for="email{{ $user->id }}" class="form-label">Email</label>
                        <input type="email" id="email{{ $user->id }}" name="email" 
                               class="form-control" value="{{ $user->email }}" required>
                    </div>
                    <div class="mb-3">
    <label for="role{{ $user->id }}" class="form-label">Role</label>
    <select id="role{{ $user->id }}" name="role" class="form-select" required>
        @foreach($roles as $role)
            <option value="{{ $role->id }}" {{ $user->hasRole($role->name) ? 'selected' : '' }}>
                {{ ucfirst($role->name) }}
            </option>
        @endforeach
    </select>
</div>


                    <div class="mb-3">
                        <label for="status{{ $user->id }}" class="form-label">Status</label>
                        <select id="status{{ $user->id }}" name="status" class="form-select">
                            <option value="active" {{ $user->status == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ $user->status == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save me-1"></i>Update
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Close
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>
