@extends('layouts.app')

@section('content')
<div class="content">
    <div class="container-fluid py-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="h3 mb-0">Edit Role</h1>
                <p class="text-secondary mb-0">Update role details and manage assigned permissions.</p>
            </div>
            <a href="{{ route('roles.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back to Roles
            </a>
        </div>

        <div class="card shadow-sm">
            <div class="card-body">
                <form action="{{ route('roles.update', $role) }}" method="POST" class="row g-4">
                    @csrf
                    @method('PATCH')

                    <div class="col-12 col-md-6">
                        <label for="name" as="form-label">Role Name</label>
                        <input
                            type="text"
                            name="name"
                            id="name"
                            class="form-control @error('name') is-invalid @enderror"
                            value="{{ old('name', $role->name) }}"
                            required
                            placeholder="e.g. supervisor"
                        >
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        <label for="permissions" class="form-label">Permissions</label>
                        <select
                            name="permissions[]"
                            id="permissions"
                            class="form-select @error('permissions') is-invalid @enderror"
                            multiple
                            size="8"
                        >
                            @foreach ($permissions as $permission)
                                <option value="{{ $permission->name }}"
                                    @selected(collect(old('permissions', $role->permissions->pluck('name')))->contains($permission->name))>
                                    {{ ucfirst($permission->name) }}
                                </option>
                            @endforeach
                        </select>
                        <div class="form-text">Hold Ctrl (Cmd on Mac) to select multiple permissions.</div>
                        @error('permissions')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12 col-md-6">
                        <label for="status" class="form-label">Status</label>
                        <select
                            name="status"
                            id="status"
                            class="form-select @error('status') is-invalid @enderror"
                            required
                        >
                            <option value="active" @selected(old('status', $role->status) == 'active')>Active</option>
                            <option value="inactive" @selected(old('status', $role->status) == 'inactive')>Inactive</option>
                        </select>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>


                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Save Changes
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

