<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>


    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    {{-- <title>{{ config('app.name', 'Laravel') }}</title> --}}
    <title>MaxPro</title>


    <!--begin::Accessibility Meta Tags-->
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=yes" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="color-scheme" content="light dark" />
    <meta name="theme-color" content="#007bff" media="(prefers-color-scheme: light)" />
    <meta name="theme-color" content="#1a1a1a" media="(prefers-color-scheme: dark)" />
    <!--end::Accessibility Meta Tags-->
    <!--begin::Primary Meta Tags-->
    <meta name="title" content="MaxPro | Dashboard" />
    <meta name="author" content="Shoaibjakhar@gmail.com" />
    <meta
      name="description"
      content=""
    />
    <meta
      name="keywords"
      content=""
    />
    <!--end::Primary Meta Tags-->
    <!--begin::Accessibility Features-->
    <!-- Skip links will be dynamically added by accessibility.js -->
    <meta name="supported-color-schemes" content="light dark" />
    {{-- AdminLTE CSS loaded via @vite below --}}
    <!--end::Accessibility Features-->
    <!--begin::Fonts-->
    <link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/@fontsource/source-sans-3@5.0.12/index.css"
      integrity="sha256-tXJfXfp6Ewt1ilPzLDtQnJV4hclT9XuaZUKyUvmyr+Q="
      crossorigin="anonymous"
      media="print"
      onload="this.media='all'"
    />
    <!--end::Fonts-->
    <!--begin::Third Party Plugin(OverlayScrollbars)-->
    <link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.11.0/styles/overlayscrollbars.min.css"
      crossorigin="anonymous"
    />
    <!--end::Third Party Plugin(OverlayScrollbars)-->
    <!--begin::Third Party Plugin(Bootstrap Icons)-->
    <link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css"
      crossorigin="anonymous"
    />
    <!--end::Third Party Plugin(Bootstrap Icons)-->
    <!--begin::DataTables CSS-->

    <link rel="stylesheet" href="{{ asset('assets/datatables/dataTables.bootstrap5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/datatables/buttons.bootstrap5.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/datatables/responsive.bootstrap5.min.css') }}">

    <style>
        /* DataTables wrapper styling */
        .dataTables_wrapper {
            padding: 0;
            width: 100%;
        }
        
        /* Custom layout: Buttons top right, Search below buttons */
        .dataTables_wrapper .row:first-child {
            margin-bottom: 0.5rem;
            display: flex;
            justify-content: flex-end;
            align-items: flex-start;
        }
        
        .dataTables_wrapper .dataTables_length {
            display: none; /* Hide length menu */
        }
        
        /* Buttons row - top right */
        .dataTables_wrapper .dt-buttons {
            margin-bottom: 0.5rem;
            text-align: right;
            display: flex;
            flex-wrap: wrap;
            gap: 0.25rem;
            justify-content: flex-end;
            order: 1;
        }
        
        .dataTables_wrapper .dt-buttons .btn {
            margin: 0;
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
            white-space: nowrap;
            background-color: #f8f9fa;
            border-color: #dee2e6;
            color: #495057;
            font-weight: 400;
        }
        
        .dataTables_wrapper .dt-buttons .btn:hover {
            background-color: #e9ecef;
            border-color: #ced4da;
            color: #212529;
        }
        
        .dataTables_wrapper .dt-buttons .btn:active,
        .dataTables_wrapper .dt-buttons .btn:focus {
            background-color: #e9ecef;
            border-color: #ced4da;
            color: #212529;
            box-shadow: 0 0 0 0.2rem rgba(0, 0, 0, 0.1);
        }
        
        /* Search filter - below buttons, right aligned */
        .dataTables_wrapper .dataTables_filter {
            float: none;
            text-align: right;
            display: inline-block;
            padding: 0;
            margin-bottom: 0.5rem;
            order: 2;
            width: 100%;
        }
        
        .dataTables_wrapper .dataTables_filter label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin: 0;
            font-weight: normal;
            white-space: nowrap;
            justify-content: flex-end;
        }
        
        .dataTables_wrapper .dataTables_filter input {
            display: inline-block;
            width: auto;
            min-width: 200px;
            margin-left: 0.5rem;
            padding: 0.375rem 0.75rem;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            background-color: #fff;
            font-size: 0.875rem;
        }
        
        .dataTables_wrapper .dataTables_filter input:focus {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        
        /* Table styling */
        .dataTables_wrapper .table {
            margin-bottom: 0;
            width: 100% !important;
        }
        
        table.dataTable {
            width: 100% !important;
        }
        
        /* Info and pagination row */
        .dataTables_wrapper .row:last-child {
            margin-top: 1rem;
            align-items: center;
            display: flex;
            flex-wrap: wrap;
        }
        
        .dataTables_wrapper .dataTables_info {
            padding-top: 0.75rem;
            padding-bottom: 0.75rem;
            float: none;
            display: inline-block;
            color: #6c757d;
            font-size: 0.875rem;
        }
        
        .dataTables_wrapper .dataTables_paginate {
            padding-top: 0.75rem;
            padding-bottom: 0.75rem;
            float: none;
            text-align: right;
            display: inline-block;
        }
        
        .dataTables_wrapper .dataTables_paginate .pagination {
            margin: 0;
            justify-content: flex-end;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .dataTables_wrapper .row:first-child {
                flex-direction: column;
                align-items: flex-end !important;
            }
            
            .dataTables_wrapper .dataTables_filter {
                width: 100%;
                margin-bottom: 0.5rem;
            }
            
            .dataTables_wrapper .dataTables_filter label {
                justify-content: flex-end;
            }
            
            .dataTables_wrapper .row:last-child {
                flex-direction: column;
                align-items: flex-start !important;
            }
            
            .dataTables_wrapper .dataTables_info,
            .dataTables_wrapper .dataTables_paginate {
                width: 100%;
                text-align: left;
                margin-bottom: 0.5rem;
            }
            
            .dataTables_wrapper .dataTables_paginate .pagination {
                justify-content: flex-start;
            }
            
            .dataTables_wrapper .dt-buttons {
                width: 100%;
                justify-content: flex-end;
            }
            
            .dataTables_wrapper .dt-buttons .btn {
                width: auto;
            }
        }
        
        /* Fix for table scroll */
        .dataTables_wrapper .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        
        /* Processing indicator styling */
        .dataTables_wrapper .dataTables_processing {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: rgba(255, 255, 255, 0.9);
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
            padding: 1rem 2rem;
            z-index: 1000;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }
    </style>
    <!--end::DataTables CSS-->
    <!--begin::Required Plugin(AdminLTE)-->
    @vite('resources/css/adminlte.css')
    <!--end::Required Plugin(AdminLTE)-->
    <!-- apexcharts -->
    <link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/apexcharts@3.37.1/dist/apexcharts.css"
      integrity="sha256-4MX+61mt9NVvvuPjUWdUdyfZfxSB1/Rf9WtqRHgG5S0="
      crossorigin="anonymous"
    />
    <!-- jsvectormap -->
    <link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/css/jsvectormap.min.css"
      integrity="sha256-+uGLJmmTKOqBr+2E6KDYs/NRsHxSkONXFHUL0fy2O/4="
      crossorigin="anonymous"
    />
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
    @stack('styles')
  </head>
  <body class="@auth layout-fixed sidebar-expand-lg sidebar-open bg-body-tertiary @else bg-body-tertiary @endauth">
    @auth
    <!--begin::App Wrapper-->
    <div class="app-wrapper">
      <!--begin::Header-->
      <nav class="app-header navbar navbar-expand bg-body">
        <!--begin::Container-->
        <div class="container-fluid">
          <!--begin::Start Navbar Links-->
          <ul class="navbar-nav">
            <li class="nav-item">
              <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button">
                <i class="bi bi-list"></i>
              </a>
            </li>
          </ul>
          <!--end::Start Navbar Links-->
          <!--begin::End Navbar Links-->
          <ul class="navbar-nav ms-auto">
            <!--begin::Navbar Search-->
            {{-- <li class="nav-item">
              <a class="nav-link" data-widget="navbar-search" href="#" role="button">
                <i class="bi bi-search"></i>
              </a>
            </li> --}}
            <!--end::Navbar Search-->
            <!--begin::Messages Dropdown Menu-->
            <li class="nav-item dropdown">
              {{-- <a class="nav-link" data-bs-toggle="dropdown" href="#">
                <i class="bi bi-chat-text"></i>
                <span class="navbar-badge badge text-bg-danger">3</span>
              </a> --}}
              <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                <a href="#" class="dropdown-item">
                  <!--begin::Message-->
                  <div class="d-flex">
                    <div class="flex-shrink-0">
                      <img
                        src="./assets/img/user1-128x128.jpg"
                        alt="User Avatar"
                        class="img-size-50 rounded-circle me-3"
                      />
                    </div>
                    <div class="flex-grow-1">
                      <h3 class="dropdown-item-title">
                        Brad Diesel
                        <span class="float-end fs-7 text-danger"
                          ><i class="bi bi-star-fill"></i
                        ></span>
                      </h3>
                      <p class="fs-7">Call me whenever you can...</p>
                      <p class="fs-7 text-secondary">
                        <i class="bi bi-clock-fill me-1"></i> 4 Hours Ago
                      </p>
                    </div>
                  </div>
                  <!--end::Message-->
                </a>
                <div class="dropdown-divider"></div>
                <a href="#" class="dropdown-item">
                  <!--begin::Message-->
                  <div class="d-flex">
                    <div class="flex-shrink-0">
                      <img
                        src="./assets/img/user8-128x128.jpg"
                        alt="User Avatar"
                        class="img-size-50 rounded-circle me-3"
                      />
                    </div>
                    <div class="flex-grow-1">
                      <h3 class="dropdown-item-title">
                        John Pierce
                        <span class="float-end fs-7 text-secondary">
                          <i class="bi bi-star-fill"></i>
                        </span>
                      </h3>
                      <p class="fs-7">I got your message bro</p>
                      <p class="fs-7 text-secondary">
                        <i class="bi bi-clock-fill me-1"></i> 4 Hours Ago
                      </p>
                    </div>
                  </div>
                  <!--end::Message-->
                </a>
                <div class="dropdown-divider"></div>
                <a href="#" class="dropdown-item">
                  <!--begin::Message-->
                  <div class="d-flex">
                    <div class="flex-shrink-0">
                      <img
                        src="./assets/img/user3-128x128.jpg"
                        alt="User Avatar"
                        class="img-size-50 rounded-circle me-3"
                      />
                    </div>
                    <div class="flex-grow-1">
                      <h3 class="dropdown-item-title">
                        Nora Silvester
                        <span class="float-end fs-7 text-warning">
                          <i class="bi bi-star-fill"></i>
                        </span>
                      </h3>
                      <p class="fs-7">The subject goes here</p>
                      <p class="fs-7 text-secondary">
                        <i class="bi bi-clock-fill me-1"></i> 4 Hours Ago
                      </p>
                    </div>
                  </div>
                  <!--end::Message-->
                </a>
                <div class="dropdown-divider"></div>
                <a href="#" class="dropdown-item dropdown-footer">See All Messages</a>
              </div>
            </li>
            <!--end::Messages Dropdown Menu-->
            <!--begin::Notifications Dropdown Menu-->
            {{-- <li class="nav-item dropdown">
              <a class="nav-link" data-bs-toggle="dropdown" href="#">
                <i class="bi bi-bell-fill"></i>
                <span class="navbar-badge badge text-bg-warning">15</span>
              </a>
              <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                <span class="dropdown-item dropdown-header">15 Notifications</span>
                <div class="dropdown-divider"></div>
                <a href="#" class="dropdown-item">
                  <i class="bi bi-envelope me-2"></i> 4 new messages
                  <span class="float-end text-secondary fs-7">3 mins</span>
                </a>
                <div class="dropdown-divider"></div>
                <a href="#" class="dropdown-item">
                  <i class="bi bi-people-fill me-2"></i> 8 friend requests
                  <span class="float-end text-secondary fs-7">12 hours</span>
                </a>
                <div class="dropdown-divider"></div>
                <a href="#" class="dropdown-item">
                  <i class="bi bi-file-earmark-fill me-2"></i> 3 new reports
                  <span class="float-end text-secondary fs-7">2 days</span>
                </a>
                <div class="dropdown-divider"></div>
                <a href="#" class="dropdown-item dropdown-footer"> See All Notifications </a>
              </div>
            </li> --}}
            <!--end::Notifications Dropdown Menu-->
            <!--begin::Fullscreen Toggle-->
            <li class="nav-item">
              <a class="nav-link" href="#" data-lte-toggle="fullscreen">
                <i data-lte-icon="maximize" class="bi bi-arrows-fullscreen"></i>
                <i data-lte-icon="minimize" class="bi bi-fullscreen-exit" style="display: none"></i>
              </a>
            </li>
            <!--end::Fullscreen Toggle-->
            <!--begin::User Menu Dropdown-->
            <li class="nav-item dropdown user-menu">
              <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                @php
                  $user = auth()->user();
                  $userPhoto = $user && $user->profile_photo && \Illuminate\Support\Facades\Storage::disk('public')->exists($user->profile_photo)
                    ? asset('storage/' . $user->profile_photo) . '?v=' . ($user->updated_at ? $user->updated_at->timestamp : time())
                    : asset('img/user2-160x160.jpg');
                @endphp
                <img
                  src="{{ $userPhoto }}"
                  class="user-image rounded-circle shadow"
                  alt="User Image"
                />
                <span class="d-none d-md-inline">{{ auth()->user() ? auth()->user()->name : 'Guest' }}</span>
              </a>
              <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                <li class="user-header text-bg-primary">
                  @php
                    $user = auth()->user();
                    $userPhoto = $user && $user->profile_photo && \Illuminate\Support\Facades\Storage::disk('public')->exists($user->profile_photo)
                      ? asset('storage/' . $user->profile_photo) . '?v=' . ($user->updated_at ? $user->updated_at->timestamp : time())
                      : asset('img/user2-160x160.jpg');
                  @endphp
                  <img
                    src="{{ $userPhoto }}"
                    class="rounded-circle shadow"
                    alt="User Image"
                  />
                  <p>
                    {{ auth()->user() ? auth()->user()->name : 'Guest' }}
                    <small>{{ auth()->user() ? 'Member since ' . (auth()->user()->created_at ? auth()->user()->created_at->format('M. Y') : '') : '' }}</small>
                  </p>
                </li>

                {{-- <li class="user-body">
                  <div class="row">
                    <div class="col-4 text-center"><a href="#">Followers</a></div>
                    <div class="col-4 text-center"><a href="#">Sales</a></div>
                    <div class="col-4 text-center"><a href="#">Friends</a></div>
                  </div>
                </li> --}}

                <li class="user-footer">
                  <a href="{{ url('edit-profile') }}" class="btn btn-default btn-flat">Profile</a>
                  <form action="{{ route('logout') }}" method="POST" class="d-inline float-end">
                    @csrf
                    <button type="submit" class="btn btn-default btn-flat">Logout</button>
                  </form>
                </li>
              </ul>
            </li>

            <!--end::User Menu Dropdown-->
          </ul>
          <!--end::End Navbar Links-->
        </div>
        <!--end::Container-->
      </nav>
      <!--end::Header-->
      <!--begin::Sidebar-->
      <aside class="app-sidebar bg-body-secondary shadow" data-bs-theme="dark">
        <!--begin::Sidebar Brand-->
        <div class="sidebar-brand">
          <!--begin::Brand Link-->
          <a href="#" class="brand-link">
            <!--begin::Brand Image-->
            @php
              $user = auth()->user();
              $brandPhoto = $user && $user->profile_photo && \Illuminate\Support\Facades\Storage::disk('public')->exists($user->profile_photo)
                ? asset('storage/' . $user->profile_photo) . '?v=' . ($user->updated_at ? $user->updated_at->timestamp : time())
                : asset('img/user2-160x160.jpg');
            @endphp
            <img
              src="{{ $brandPhoto }}"
              alt="Profile Photo"
              class="brand-image opacity-75 shadow rounded-circle"
              style="object-fit: cover;"
            />
            <!--end::Brand Image-->
            <!--begin::Brand Text-->
            <span class="brand-text fw-light">
              @auth
                {{ auth()->user()->name }}
                @if(auth()->user()->roles->isNotEmpty())
                  <small class="d-block text-muted" style="font-size: 0.7em;">{{ auth()->user()->roles->pluck('name')->join(', ') }}</small>
                @endif
              @endauth
            </span>
            <!--end::Brand Text-->
          </a>
          <!--end::Brand Link-->
        </div>
        <!--end::Sidebar Brand-->
        <!--begin::Sidebar Wrapper-->
        <div class="sidebar-wrapper">
          <nav class="mt-2">
            <!--begin::Sidebar Menu-->
            <ul
              class="nav sidebar-menu flex-column"
              data-lte-toggle="treeview"
              role="navigation"
              aria-label="Main navigation"
              data-accordion="false"
              id="navigation"
            >
              @can('view-dashboard')
              <li class="nav-item">
                <a href="{{ url('dashboard') }}"
                  class="nav-link {{ request()->is('dashboard') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-speedometer2"></i>
                  <p>Dashboard</p>
                </a>
              </li>
              @endcan

              @can('view-pos')
              <li class="nav-item">
                <a href="{{ url('create-pos') }}"
                  class="nav-link {{ request()->is('create-pos') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-cash-stack"></i>
                  <p>Pos</p>
                </a>
              </li>
              @endcan

              @can('view-product')
              <li class="nav-item">
                <a href="{{ url('products') }}"
                  class="nav-link {{ request()->is('products') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-basket"></i>
                  <p>Products</p>
                </a>
              </li>
              @endcan

              @can('view-pack-sizes')
              <li class="nav-item">
                <a href="{{ route('pack-sizes.index') }}"
                  class="nav-link {{ request()->is('pack-sizes') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-grid-3x3-gap"></i>
                  <p>Pack Sizes</p>
                </a>
              </li>
              @endcan

              @can('view-inventory')
              <li class="nav-item">
                <a href="{{ url('inventory') }}"
                  class="nav-link {{ request()->is('inventory') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-clipboard-data"></i>
                  <p>Inventory</p>
                </a>
              </li>
              @endcan

              @can('view-stockin')
              <li class="nav-item">
                <a href="{{ url('stock-in-view') }}"
                  class="nav-link {{ request()->is('stock-in-view') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-box-arrow-in-down"></i>
                  <p>Stock In</p>
                </a>
              </li>
              @endcan

              @can('view-stockout')
              <li class="nav-item">
                <a href="{{ url('stock-out-view') }}"
                  class="nav-link {{ request()->is('stock-out-view') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-box-arrow-up"></i>
                  <p>Stock Out</p>
                </a>
              </li>
              @endcan

              @can('view-sales')
              <li class="nav-item">
                <a href="{{ url('sales') }}"
                  class="nav-link {{ request()->is('sales') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-graph-up-arrow"></i>
                  <p>Sales</p>
                </a>
              </li>
              @endcan

              @can('view-accounting')
              <li class="nav-item">
                <a href="{{ route('accounting.index') }}"
                  class="nav-link {{ request()->is('accounting') || request()->is('accounting/*') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-calculator"></i>
                  <p>Accounting</p>
                </a>
              </li>
              @endcan

              @can('view-users')
              <li class="nav-item">
                <a href="{{ route('users.index') }}"
                  class="nav-link {{ request()->is('users') || request()->is('users/*') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-people"></i>
                  <p>Users</p>
                </a>
              </li>
              @endcan

              @can('view-roles')
              <li class="nav-item">
                <a href="{{ route('roles.index') }}"
                  class="nav-link {{ request()->is('roles') || request()->is('roles/*') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-shield-lock"></i>
                  <p>Roles</p>
                </a>
              </li>
              @endcan

              @can('view-permissions')
              <li class="nav-item">
                <a href="{{ route('permissions.index') }}"
                  class="nav-link {{ request()->is('permissions') || request()->is('permissions/*') ? 'active bg-primary text-white rounded' : '' }}">
                  <i class="nav-icon bi bi-key"></i>
                  <p>Permissions</p>
                </a>
              </li>
              @endcan
                <li class="nav-item mt-3">
                  <a href="{{ route('logout') }}" 
                    class="nav-link text-danger"
                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                      <i class="nav-icon bi bi-box-arrow-right"></i>
                      <p>Logout</p>
                  </a>

                  <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                      @csrf
                  </form>
              </li>
            
            </ul>
            <!--end::Sidebar Menu-->
          </nav>
        </div>
        <!--end::Sidebar Wrapper-->
      </aside>
      <!--end::Sidebar-->
      <!--begin::App Main-->
      <div class="content-wrapper p-4">
      @yield('content')
    </div>
      <!--end::App Main-->
      <!--begin::Footer-->
      <footer class="app-footer">
        <!--begin::To the end-->
        <!-- <div class="float-end d-none d-sm-inline">Anything you want</div> -->
        <!--end::To the end-->
        <!--begin::Copyright-->
        <strong>
          Copyright &copy; 2016-2025&nbsp;
          <a href="https://www.fiverr.com/shoaibakbar11" class="text-decoration-none">Softwebies</a>.
        </strong>
        All rights reserved.
        <!--end::Copyright-->
      </footer>
      <!--end::Footer-->
    </div>
    <!--end::App Wrapper-->
    @else
    <div class="min-vh-100 d-flex align-items-center justify-content-center py-5">
      @yield('content')
    </div>
    @endauth
    <!--begin::Script-->
    <!--begin::Third Party Plugin(OverlayScrollbars)-->
    <script
      src="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.11.0/browser/overlayscrollbars.browser.es6.min.js"
      crossorigin="anonymous"
    ></script>
    <!--end::Third Party Plugin(OverlayScrollbars)--><!--begin::Required Plugin(popperjs for Bootstrap 5)-->
    <script
      src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
      crossorigin="anonymous"
    ></script>
    <!--end::Required Plugin(popperjs for Bootstrap 5)--><!--begin::Required Plugin(Bootstrap 5)-->
    <script
      src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.min.js"
      crossorigin="anonymous"
    ></script>
    <!--end::Required Plugin(Bootstrap 5)--><!--begin::Required Plugin(AdminLTE)-->
    {{-- <script src="./js/adminlte.js" ></script> --}}
    @vite('resources/js/adminlte.js')

    <!--end::Required Plugin(AdminLTE)--><!--begin::OverlayScrollbars Configure-->
    <script>
      const SELECTOR_SIDEBAR_WRAPPER = '.sidebar-wrapper';
      const Default = {
        scrollbarTheme: 'os-theme-light',
        scrollbarAutoHide: 'leave',
        scrollbarClickScroll: true,
      };
      document.addEventListener('DOMContentLoaded', function () {
        const sidebarWrapper = document.querySelector(SELECTOR_SIDEBAR_WRAPPER);
        if (sidebarWrapper && OverlayScrollbarsGlobal?.OverlayScrollbars !== undefined) {
          OverlayScrollbarsGlobal.OverlayScrollbars(sidebarWrapper, {
            scrollbars: {
              theme: Default.scrollbarTheme,
              autoHide: Default.scrollbarAutoHide,
              clickScroll: Default.scrollbarClickScroll,
            },
          });
        }
      });
    </script>
    <!--end::OverlayScrollbars Configure-->
    <!--begin::DataTables JS-->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    <!--end::DataTables JS-->
    <!-- OPTIONAL SCRIPTS -->
    <!-- sortablejs -->
    <script
      src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"
      crossorigin="anonymous"
    ></script>
    <!-- sortablejs -->
    <script>
      new Sortable(document.querySelector('.connectedSortable'), {
        group: 'shared',
        handle: '.card-header',
      });

      const cardHeaders = document.querySelectorAll('.connectedSortable .card-header');
      cardHeaders.forEach((cardHeader) => {
        cardHeader.style.cursor = 'move';
      });
    </script>
    <!-- apexcharts -->
    <script
      src="https://cdn.jsdelivr.net/npm/apexcharts@3.37.1/dist/apexcharts.min.js"
      integrity="sha256-+vh8GkaU7C9/wbSLIcwq82tQ2wTf44aOHA8HlBMwRI8="
      crossorigin="anonymous"
    ></script>
    <!-- ChartJS -->
    <script>
      // NOTICE!! DO NOT USE ANY OF THIS JAVASCRIPT
      // IT'S ALL JUST JUNK FOR DEMO
      // ++++++++++++++++++++++++++++++++++++++++++

      const sales_chart_options = {
        series: [
          {
            name: 'Digital Goods',
            data: [28, 48, 40, 19, 86, 27, 90],
          },
          {
            name: 'Electronics',
            data: [65, 59, 80, 81, 56, 55, 40],
          },
        ],
        chart: {
          height: 300,
          type: 'area',
          toolbar: {
            show: false,
          },
        },
        legend: {
          show: false,
        },
        colors: ['#0d6efd', '#20c997'],
        dataLabels: {
          enabled: false,
        },
        stroke: {
          curve: 'smooth',
        },
        xaxis: {
          type: 'datetime',
          categories: [
            '2023-01-01',
            '2023-02-01',
            '2023-03-01',
            '2023-04-01',
            '2023-05-01',
            '2023-06-01',
            '2023-07-01',
          ],
        },
        tooltip: {
          x: {
            format: 'MMMM yyyy',
          },
        },
      };

      const sales_chart = new ApexCharts(
        document.querySelector('#revenue-chart'),
        sales_chart_options,
      );
      sales_chart.render();
    </script>
    <!-- jsvectormap -->
    <script
      src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/js/jsvectormap.min.js"
      integrity="sha256-/t1nN2956BT869E6H4V1dnt0X5pAQHPytli+1nTZm2Y="
      crossorigin="anonymous"
    ></script>
    <script
      src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/maps/world.js"
      integrity="sha256-XPpPaZlU8S/HWf7FZLAncLg2SAkP8ScUTII89x9D3lY="
      crossorigin="anonymous"
    ></script>
    <!-- jsvectormap -->
    <script>
      // World map by jsVectorMap
      new jsVectorMap({
        selector: '#world-map',
        map: 'world',
      });

      // Sparkline charts
      const option_sparkline1 = {
        series: [
          {
            data: [1000, 1200, 920, 927, 931, 1027, 819, 930, 1021],
          },
        ],
        chart: {
          type: 'area',
          height: 50,
          sparkline: {
            enabled: true,
          },
        },
        stroke: {
          curve: 'straight',
        },
        fill: {
          opacity: 0.3,
        },
        yaxis: {
          min: 0,
        },
        colors: ['#DCE6EC'],
      };

      const sparkline1 = new ApexCharts(document.querySelector('#sparkline-1'), option_sparkline1);
      sparkline1.render();

      const option_sparkline2 = {
        series: [
          {
            data: [515, 519, 520, 522, 652, 810, 370, 627, 319, 630, 921],
          },
        ],
        chart: {
          type: 'area',
          height: 50,
          sparkline: {
            enabled: true,
          },
        },
        stroke: {
          curve: 'straight',
        },
        fill: {
          opacity: 0.3,
        },
        yaxis: {
          min: 0,
        },
        colors: ['#DCE6EC'],
      };

      const sparkline2 = new ApexCharts(document.querySelector('#sparkline-2'), option_sparkline2);
      sparkline2.render();

      const option_sparkline3 = {
        series: [
          {
            data: [15, 19, 20, 22, 33, 27, 31, 27, 19, 30, 21],
          },
        ],
        chart: {
          type: 'area',
          height: 50,
          sparkline: {
            enabled: true,
          },
        },
        stroke: {
          curve: 'straight',
        },
        fill: {
          opacity: 0.3,
        },
        yaxis: {
          min: 0,
        },
        colors: ['#DCE6EC'],
      };

      const sparkline3 = new ApexCharts(document.querySelector('#sparkline-3'), option_sparkline3);
      sparkline3.render();
    </script>
    @stack('scripts')
    <!--end::Script-->
  </body>
</html>
