@extends('layouts.app')

@section('content')
<div class="container mt-5">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0">Sales</h2>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table id="salesTable" class="table table-hover table-bordered align-middle text-center mb-0 table-striped">
                        <thead class="table-primary">
                            <tr>
                                <th>#</th>
                                <th>Total Products</th>
                                <th>Fuel Charges</th>
                                <th>Other Charges</th>
                                <th>Subtotal</th>
                                <th>Total</th>
                                <th>Sale Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($orders as $key => $order)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td class="text-start" style="line-height: 1.5;">
                                        @php
                                            $items = is_array($order->order_snap) ? $order->order_snap : json_decode($order->order_snap, true) ?? [];
                                        @endphp
                                        <ol>
                                            @foreach($items as $item)
                                                @php
                                                    $product = \App\Models\Product::find($item['sku'] ?? null);
                                                @endphp
                                                <li>{{ $product->name ?? 'N/A' }}</li>
                                            @endforeach
                                        </ol>
                                    </td>
                                    <td>{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($order->fuel_charges, 2) }}</td>
                                    <td>{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($order->other_charges, 2) }}</td>
                                    <td>{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($order->sub_total, 2) }}</td>
                                    <td>{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($order->total, 2) }}</td>
                                    <td>{{ \Carbon\Carbon::parse($order->sale_date)->format('d M Y') }}</td>
                                    <td>
                                        <a href="{{ url('order-details/' . $order->id) }}" class="btn btn-sm btn-primary">
                                            View Details
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="text-center text-muted">No orders found</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
            </div>
        </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('#salesTable').DataTable({
        responsive: true,
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        //order: [[6, 'desc']],
        columnDefs: [
            { orderable: false, targets: 7 }
        ],
         //AGAR BUTTONS SHOW KARAVANY HAIN EXCEL,PDF WAGIRA KY TO ISY NICHY BUTTONS KO UN COMMENT KRNA HY 
        //dom: '<"row"<"col-sm-12"B><"col-sm-12"f>>' +  FOR SHOW BUTTONS +SEARCH BAR 
        dom: '<"row"<"col-sm-12"f>>' + //FOR SEARCH BAR ONLY
             '<"row"<"col-sm-12"tr>>' +
             '<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
        processing: true,
        deferRender: true,
        buttons: [
            {
                extend: 'excel',
                text: '<i class="bi bi-file-earmark-spreadsheet me-1"></i>Excel',
                className: 'btn btn-sm',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6]
                }
            },
            {
                extend: 'pdf',
                text: '<i class="bi bi-file-earmark-pdf me-1"></i>PDF',
                className: 'btn btn-sm',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6]
                },
                customize: function(doc) {
                    doc.defaultStyle.fontSize = 9;
                    doc.styles.tableHeader.fontSize = 10;
                }
            },
            {
                extend: 'csv',
                text: '<i class="bi bi-filetype-csv me-1"></i>CSV',
                className: 'btn btn-sm',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6]
                }
            },
            {
                extend: 'print',
                text: '<i class="bi bi-printer me-1"></i>Print',
                className: 'btn btn-sm',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6]
                }
            }
        ],
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            infoEmpty: "Showing 0 to 0 of 0 entries",
            infoFiltered: "(filtered from _MAX_ total entries)",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            },
            emptyTable: "No data available in table",
            zeroRecords: "No matching records found"
        }
    });
});
</script>
@endpush
@endsection
