@extends('layouts.app')

@section('content')
<div class="container mt-5">

    {{-- Header: Order ID left, Sale Date right --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="p-2 border rounded">
            <strong>Order ID:</strong> {{ $order->id }}
        </div>
        <div class="p-2 border rounded">
            <strong>Sale Date:</strong> {{ \Carbon\Carbon::parse($order->sale_date)->format('d M Y') }}
        </div>
    </div>

    {{-- Products Table --}}
    <div class="card shadow-sm mb-4">
        <div class="card-body p-3">
            <div class="table-responsive">
                <table class="table table-bordered text-center align-middle mb-0">
                    <thead class="table-primary">
                        <tr>
                            <th>#</th>
                            <th class="text-start">Product Name</th>
                            <th>Quantity</th>
                            <th>Price</th>
                            <th>Subtotal</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($orderItems as $key => $item)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td class="text-start">
                                    @php
                                        $product = \App\Models\Product::find($item['sku'] ?? null);
                                        $productName = $product->name ?? ($item['name'] ?? 'N/A');
                                        $packCount = $item['pack_count'] ?? $item['quantity'] ?? 0;
                                        $unitPrice = $item['unit_price'] ?? $item['price'] ?? 0;
                                        $packSizeName = $item['pack_size']['name'] ?? null;
                                        $packSizeQuantity = $item['pack_size']['bottle_quantity'] ?? ($item['pack_size_quantity'] ?? null);
                                        $totalBottles = $item['bottle_quantity'] ?? ($packSizeQuantity ? $packCount * $packSizeQuantity : null);
                                    @endphp
                                    {{ $productName }}
                                    @if($packSizeName && $packSizeQuantity)
                                        <div class="text-secondary small">
                                            {{ $packSizeName }} • {{ $packSizeQuantity }} bottles/pack
                                        </div>
                                    @endif
                                </td>
                                <td>
                                    {{ $packCount }} pack(s)
                                    @if($totalBottles)
                                        <div class="text-secondary small">{{ $totalBottles }} bottles</div>
                                    @endif
                                </td>
                                <td>{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($unitPrice, 2) }}</td>
                                <td>{{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($unitPrice * $packCount, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">No items found in this order.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Charges and totals --}}
            <div class="row mt-4">
                <div class="col-md-3">
                    <strong>Fuel Charges:</strong>
                    {{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($order->fuel_charges, 2) }}
                </div>
                <div class="col-md-3">
                    <strong>Other Charges:</strong>
                    {{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($order->other_charges, 2) }}
                </div>
                <div class="col-md-3">
                    <strong>Other Charges Detail:</strong>
                    {{ $order->other_charges_detail ?? '—' }}
                </div>
                <div class="col-md-3 text-end">
                    <strong>Subtotal:</strong>
                    {{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($order->sub_total, 2) }}
                </div>
            </div>

            <div class="row mt-3">
                <div class="col text-end">
                    <h4>Total: {{ env('APP_CURRENCY_SYMBOL') }}{{ number_format($order->total, 2) }}</h4>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-start">
        <a href="{{ url('sales') }}" class="btn btn-outline-secondary">Back to Stock Out List</a>
    </div>

</div>
@endsection
