@extends('layouts.app')

@section('content')
<div class="container mt-5">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0">Inventory List</h2>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table id="inventoryTable" class="table table-hover table-bordered align-middle text-center mb-0 table-striped">
                        <thead class="table-primary">
                            <tr>
                                <th>#</th>
                                <th>Product Name</th>
                                <th>Total Stock In </th>
                                <th>Stock In Available</th>
                                <th>Total Stock Out </th>
                                <th>Total Sold</th>
                                <th>Current Stock(POS)</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($inventories as $key => $inventory)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $inventory->name }}</td>
                                    <td>{{ $inventory->total_stock_in }}</td>
                                    <td>{{ $inventory->availble_stock_in }}</td>
                                    <td>{{ $inventory->total_stock_out }}</td>
                                    <td>{{ $inventory->total_sold }}</td>
                                    <td>{{ $inventory->current_stock }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center text-muted">No products found</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
            </div>
        </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('#inventoryTable').DataTable({
        responsive: true,
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        order: [[0, 'asc']], 
        //AGAR BUTTONS SHOW KARAVANY HAIN EXCEL,PDF WAGIRA KY TO ISY NICHY BUTTONS KO UN COMMENT KRNA HY 
        //dom: '<"row"<"col-sm-12"B><"col-sm-12"f>>' +  FOR SHOW BUTTONS +SEARCH BAR 
        dom: '<"row"<"col-sm-12"f>>' + //FOR SEARCH BAR ONLY
             '<"row"<"col-sm-12"tr>>' +
             '<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
        processing: true,
        deferRender: true,
        buttons: [
            {
                extend: 'excel',
                text: '<i class="bi bi-file-earmark-spreadsheet me-1"></i>Excel',
                className: 'btn btn-sm',
                exportOptions: {
                    columns: ':visible'
                }
            },
            {
                extend: 'pdf',
                text: '<i class="bi bi-file-earmark-pdf me-1"></i>PDF',
                className: 'btn btn-sm',
                exportOptions: {
                    columns: ':visible'
                },
                customize: function(doc) {
                    doc.defaultStyle.fontSize = 9;
                    doc.styles.tableHeader.fontSize = 10;
                }
            },
            {
                extend: 'csv',
                text: '<i class="bi bi-filetype-csv me-1"></i>CSV',
                className: 'btn btn-sm',
                exportOptions: {
                    columns: ':visible'
                }
            },
            {
                extend: 'print',
                text: '<i class="bi bi-printer me-1"></i>Print',
                className: 'btn btn-sm',
                exportOptions: {
                    columns: ':visible'
                }
            }
        ],
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            infoEmpty: "Showing 0 to 0 of 0 entries",
            infoFiltered: "(filtered from _MAX_ total entries)",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            },
            emptyTable: "No data available in table",
            zeroRecords: "No matching records found"
        }
    });
});
</script>
@endpush
@endsection
