<div class="modal fade" id="editInventoryModal{{ $inventory->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ url('update-inventory/'.$inventory->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title">Edit Inventory</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <!-- Product Dropdown -->
                    <div class="mb-3">
                        <label>Product</label>
                        <select name="product_id" id="productSelect{{ $inventory->id }}" class="form-select" required>
                            <option value="">Select Product</option>
                            @foreach(App\Models\Product::where('status', 1)->get() as $product)
                                <option value="{{ $product->id }}" data-price="{{ $product->purchase_price }}"
                                    {{ $inventory->product_id == $product->id ? 'selected' : '' }}>
                                    {{ $product->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Total Quantity -->
                    <div class="mb-3">
                        <label>Total Quantity</label>
                        <input type="number" name="total_quantity" id="totalQuantity{{ $inventory->id }}"
                            class="form-control" value="{{ $inventory->total_quantity }}" required min="0">
                    </div>

                    <!-- Current Stock -->
                    <div class="mb-3">
                        <label>Current Stock</label>
                        <input type="number" name="current_stock" id="currentStock{{ $inventory->id }}"
                            class="form-control" value="{{ $inventory->current_stock }}" required min="0">
                    </div>

                    <!-- Inventory Price (readonly, live) -->
                    <div class="mb-3">
                        <label>Inventory Price</label>
                        <input type="text" id="inventoryPrice{{ $inventory->id }}" class="form-control"
                            value="${{ number_format($inventory->inventory_price, 2) }}" readonly>
                        <small class="text-muted">Calculated as Purchase Price × Total Quantity</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success">Update Inventory</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript for live calculation -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const productSelect = document.getElementById('productSelect{{ $inventory->id }}');
        const totalQuantity = document.getElementById('totalQuantity{{ $inventory->id }}');
        const inventoryPrice = document.getElementById('inventoryPrice{{ $inventory->id }}');

        function calculateInventoryPrice() {
            const selectedOption = productSelect.options[productSelect.selectedIndex];
            const purchasePrice = parseFloat(selectedOption.dataset.price) || 0;
            const quantity = parseFloat(totalQuantity.value) || 0;
            const total = purchasePrice * quantity;

            inventoryPrice.value = total ? `$${total.toFixed(2)}` : 'Calculated Automatically';
        }

        productSelect.addEventListener('change', calculateInventoryPrice);
        totalQuantity.addEventListener('input', calculateInventoryPrice);
    });
</script>
