<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class StockOut extends Model
{
    use HasFactory, HasUuids;

    protected $table = 'stock_out';

    protected $fillable = [
        'product_id',
        'quantity',
        'stock_out_date',
        'created_by',
    ];

    protected static function booted()
    {
        static::creating(function ($model) {
            $model->updated_at = null;
        });

        static::updating(function ($model) {
            $model->updated_at = now();
        });
    }

    public function creator(){
        return $this->belongsTo(User::class, 'created_by');
    }
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id', 'id');
    }
}
