<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class StockIn extends Model
{
    use HasFactory, HasUuids;

    protected $table = 'stock_in';

    protected $fillable = [
        'product_id',
        'quantity',
        'total_price',
        'unit_price',
        'created_by',
    ];
       protected static function booted()
    {
        static::creating(function ($model) {
            $model->updated_at = null;
        });

        static::updating(function ($model) {
            $model->updated_at = now();
        });
    }

    public function creator(){
        return $this->belongsTo(User::class, 'created_by');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id', 'id');
    }
}
