<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class OrderDetail extends Model
{
    use HasFactory, HasUuids;

    protected $keyType = 'string';
    public $incrementing = false;

    protected $fillable = [
        'order_id',
        'product_id',
        'unit_price',
        'total_price',
        'qty',
    ];
    
       protected static function booted()
    {
        static::creating(function ($model) {
            $model->updated_at = null;
        });

        static::updating(function ($model) {
            $model->updated_at = now();
        });
    }

    /**
     * Relationship: Each OrderDetail belongs to an Order
     */
    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id', 'id');
    }
    public function product()
{
    return $this->belongsTo(Product::class, 'product_id', 'id');
}
}
