<?php

namespace App\Http\Controllers;

use App\Models\PackSize;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class PackSizeController extends Controller
{
    public function index(): View
    {
        $packSizes = PackSize::orderBy('id', 'desc')->get();

        return view('PackSize.index', compact('packSizes'));
    }

    public function store(Request $request): RedirectResponse
    {
        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'quantity' => ['required', 'integer', 'min:1'],
            'description' => ['nullable', 'string'],
        ]);

        PackSize::create($validated);

        return redirect()
            ->route('pack-sizes.index')
            ->with('success', 'Pack size added successfully!');
    }

     public function update(Request $request, PackSize $packSize): RedirectResponse
    {
        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'quantity' => ['required', 'integer', 'min:1'],
            'description' => ['nullable', 'string'],
        ]);

        $packSize->update($validated);

        return redirect()
            ->route('pack-sizes.index')
            ->with('success', 'Pack size updated successfully!');
    }

    public function destroy(PackSize $packSize): RedirectResponse
    {
        $packSize->delete();

        return redirect()
            ->route('pack-sizes.index')
            ->with('success', 'Pack size deleted successfully!');
    }
}
